<?php
/* 
Template Name: Contact
*/
	global $wp_query;
    if(isset($wp_query))
    	$content_array = $wp_query->get_queried_object();
	if(isset($content_array->ID)){
    	$post_id = $content_array->ID;
	}

	$template_uri = get_template_directory_uri();
	
	// Page Options
		$pagecustoms = getOptions($post_id);	

		if(isset($pagecustoms["alterego_headline_active"])){
			$alterego_headline_active = "on";
			$alterego_head_box_title = $pagecustoms["alterego_head_box_title"];
			$alterego_head_box_content = $pagecustoms["alterego_head_box_content"];
			$alterego_head_box_layout = split("-", $pagecustoms["alterego_head_box_layout"]);
		}
		else{
			$alterego_headline_active = "off";
			$alterego_head_box_title = "";
			$alterego_head_box_content = "";
		}

		if(isset($pagecustoms["alterego_header_title"]) && $pagecustoms["alterego_header_title"]!="")
			$alterego_headline = $pagecustoms["alterego_header_title"];
		else
			$alterego_headline = get_the_title($post_id);

		// Sidebar
			if(isset($pagecustoms["alterego_activate_sidebar"])){
				$alterego_activate_sidebar="on";
				$sidebar_orientation = $pagecustoms["alterego_sidebar_orientation"];
				$sidebar = $pagecustoms["alterego_sidebar"];
				if($sidebar_orientation=="right"){
					$content_style="";
					$content_lastcolumn = "";
					$sidebar_lastcolumn = "lastcolumn";
				}
				else{
					$content_style='style="float:right;"';
					$content_lastcolumn = "lastcolumn";
					$sidebar_lastcolumn = "";
				}
			}
			else{
				$alterego_activate_sidebar="off";
			}

	// Language Options
		$contact_labelname = __('Name *', 'alterego');
		$contact_labelemail = __('Email *', 'alterego');
		$contact_labelphone = __('Phone', 'alterego');
		$contact_labelmessage = __('Message *', 'alterego');
		$contact_buttonsubmit = __('Send Message', 'alterego');
		$contact_messageerror = __('Error! Please correct marked fields.', 'alterego');
		$contact_messagesuccess = __('Message send successfully!', 'alterego');
		$contact_messagesending = __('Sending...', 'alterego');
		$contact_send = __('Send', 'alterego');

	// Contact Options
		if ( function_exists( 'get_option_tree') ) {
				//Google Data
				$gmapaddress = get_option_tree('alterego_contact_gmap_address');
				$gmapzoom = get_option_tree('alterego_contact_gmap_zoom');
				if($gmapzoom=="") $gmapzoom=14;
				$contact_content_position = get_option_tree('alterego_contact_content_position');
		}	

?>    
<?php get_header(); ?>
						<div class="divide10"></div>
						<div id="google_map_wrap"><div id="google_map"></div></div>
						  <script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script> 
						  <script type="text/javascript" src="<?php echo $template_uri;?>/js/jquery.gmap.js"></script> 
						  <script language="javascript"> 
									jQuery(window).load(function(){
										//set google map with marker
										jQuery("#google_map").gMap({
											mapTypeControl:         false,
										    zoomControl:            true,
										    panControl:             true,
										    scaleControl:           true,
										    streetViewControl:      true,
											markers: [{
														address: '<?php echo $gmapaddress; ?>'
													}],
											zoom: <?php echo $gmapzoom; ?>,
											icon: {
												image: '<?php echo $template_uri;?>/images/navigation/pin.png',
												iconsize: [68, 40],
												
												shadow: 'images/icons/shadow.png'
											}
										});
									});
								</script> 		
									
						<div class="colordivider"></div>
							<?php if($alterego_headline_active!="off"){
				            ?>
								<div class="bannerfooter">
									<?php if(!isset($alterego_head_box_layout[2])){ ?>
										<div class="<?php echo $alterego_head_box_layout[0];?>">
											<h3><?php echo $alterego_head_box_title; ?></h3>
										</div>
										<div class="<?php echo $alterego_head_box_layout[1];?> lastcolumn">								
											<div class="leftfloat hordiv"><h5><?php echo $alterego_head_box_content;?></h5></div>
										</div>
									<?php }else { ?>
											<div class="leftfloat"> <h3><?php echo $alterego_head_box_title;?></h3></div>
											<div>
												<div class="leftfloat hordiv"><h5><?php echo $alterego_head_box_content;?></h5></div>
												<?php if($pagecustoms['alterego_head_box_button_type']=="purchase"){ ?>
													<div class="rightfloat purchase main_bg_color_1"><a href="<?php echo $pagecustoms['alterego_head_box_button_link']?>"><h5><?php echo $pagecustoms['alterego_head_box_button_text']?></h5></a></div>
												<?php } else { ?>
													<div class="rightfloat" style="padding-top: 18px;"><a  href="<?php echo $pagecustoms['alterego_head_box_button_link']?>" class="button main_bg_color_1 r20"><?php echo $pagecustoms['alterego_head_box_button_text']?></a></div> 
												<?php } ?>
											</div>
									<?php } ?>
									<div class="clear"></div>							
								</div>
								<div class="clear"></div>					
								<div class="homebanner_shadow"></div>
							<?php } ?>
								
						
						<div class="clear"></div>
						<div class="divide5"></div>
						<!--
						##############################
							- CONTENT -
						##############################
						-->
									
						
						<?php if($alterego_activate_sidebar=="on"){
							echo '<div class="three_fourth withsidebar '.$content_lastcolumn.'" '.$content_style.'>';
						}?>
						
						
							<h3><?php echo $alterego_headline; ?></h3>
							<?php if(have_posts()) : while(have_posts()) : the_post();?>
								<?php if ($contact_content_position=="above") the_content(); ?>
								<div class="two_third">
									<div class="divide5"></div>
											<div class="contactform">
													<form id="contactform" method="get" action="/search">
															<input type="text" id="name" name="name" value="<?php echo $contact_labelname;?>" class="inputbox requiredfield" />
															<div class="clear"></div>
															<div class="divide25"></div>
															<input type="text" id="email" name="email" value="<?php echo $contact_labelemail;?>" class="inputbox requiredfield" />
															<div class="clear"></div>
															<div class="divide25"></div>
															<input type="text" id="phone" name="phone" value="<?php echo $contact_labelphone;?>" class="inputbox last" />													
															<div class="clear"></div>
															<div class="divide25"></div>
															<textarea rows="8" id="message" name="message" value="<?php echo $contact_labelmessage;?>" class="inputbox textbox requiredfield"></textarea>
															<div class="clear"></div>
															<div class="divide25"></div>
															<input type="submit" id="signup_go" value="<?php echo $contact_send;?>" class="button alterego_send_button_color submit" />																													
													
													<span class="errormessage"><?php echo $contact_messageerror ?></span>
										            <span class="successmessage"><?php echo $contact_messagesuccess ?></span>
										            <span class="sendingmessage"><?php echo $contact_messagesending ?></span> 
													</form>
													<div class="divide50"></div>

										</div>
															
								</div>
								<div class="one_third lastcolumn">
									<p><?php echo do_shortcode(get_option_tree('alterego_contact_info')); ?></p>
								</div>
								<div class="clear"></div>
								<?php if ($contact_content_position=="under") the_content(); ?>
							<?php endwhile; endif; //have_posts 
     ?>	
							
					<div class="clear"></div>
					<div class="divide30"></div>
				    <?php if($alterego_activate_sidebar=="on"){?>
										</div>
										<div class="one_fourth sidebar <?php echo $sidebar_lastcolumn;?>" style="float:<?php echo $sidebar_orientation; ?>">
											<div class="divide5"></div>
											<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar($sidebar) ) : ?>
									                <h5 class="widgettitle">Sidebar Widget</h5>
							                        	Please configure this Widget in the Admin Panel under Appearance -> Widgets
							                        <div class="divide25"></div>					
													<div class="pagedivider"></div>
													<div class="divide25"></div>
							                <?php endif;?>
										</div>
					<?php } ?>
					<div class="clear"></div>
							</div>
<?php get_footer(); ?>